<?php



class ManufacturerController extends ManufacturerControllerCore

{

public function initContent()

	{

		parent::initContent();



		if (Validate::isLoadedObject($this->manufacturer) && $this->manufacturer->active && $this->manufacturer->isAssociatedToShop())

		{

			$this->productSort();

			$this->assignOne();

			$this->setTemplate(_PS_THEME_DIR_.'manufacturer.tpl');

		}

		else

		{

			$this->assignAll();

			$this->setTemplate(_PS_THEME_DIR_.'manufacturer-list.tpl');

		}

	}

        protected function assignOne()

	{

		$nbProducts = $this->manufacturer->getProducts($this->manufacturer->id, null, null, null, $this->orderBy, $this->orderWay, true);

		$this->pagination((int)$nbProducts);

                

                

               $allproducts=$this->manufacturer->getProducts($this->manufacturer->id, $this->context->language->id, (int)$this->p, (int)$this->n, $this->orderBy, $this->orderWay);

               $image_id=array();

               for($i=0;$i<$nbProducts;$i++){

                $product_id=$allproducts[$i]['id_product'];

                $sql= "SELECT * FROM  `"._DB_PREFIX_."image` WHERE  `id_product` =  '$product_id' AND cover =  '0' ORDER BY  `id_image` ";

                $result= Db::getInstance()->ExecuteS($sql);

                $outdata=$result[0];

                $image_id[$product_id]=$outdata['id_image'];

              }

               $this->context->smarty->assign('addimages',$image_id);

                       

		$this->context->smarty->assign(array(

			'nb_products' => $nbProducts,

			'products' => $this->manufacturer->getProducts($this->manufacturer->id, $this->context->language->id, (int)$this->p, (int)$this->n, $this->orderBy, $this->orderWay),

			'path' => ($this->manufacturer->active ? Tools::safeOutput($this->manufacturer->name) : ''),

			'manufacturer' => $this->manufacturer,

			'comparator_max_item' => Configuration::get('PS_COMPARATOR_MAX_ITEM'))

			);

	}



	/**

	 * Assign template vars if displaying the manufacturer list

	 */

	protected function assignAll()

	{

		if (Configuration::get('PS_DISPLAY_SUPPLIERS'))

		{

			$id_current_shop_group = Shop::getContextShopGroupID();

			$data = Manufacturer::getManufacturers(true, $this->context->language->id, true, false, false, false, $id_current_shop_group);

			$nbProducts = count($data);

			$this->pagination($nbProducts);





			foreach ($data as &$item)

				$item['image'] = (!file_exists(_PS_MANU_IMG_DIR_.'/'.$item['id_manufacturer'].'-medium_default.jpg')) ? $this->context->language->iso_code.'-default' : $item['id_manufacturer'];



			$this->context->smarty->assign(array(

				'pages_nb' => ceil($nbProducts / (int)($this->n)),

				'nbManufacturers' => $nbProducts,

				'mediumSize' => Image::getSize('medium_default'),

				'manufacturers' => $data,

				'add_prod_display' => Configuration::get('PS_ATTRIBUTE_CATEGORY_DISPLAY'),

			));

		}

		else

			$this->context->smarty->assign('nbManufacturers', 0);

	}

}



